//
//  CMS_Timestamps.swift
//  Composr Mobile SDK
//
//  Created by Aaswini on 06/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
/*
 
 CMS_Timestamps
 
 get_timezoned_date_time(int timestamp) - turns a unix timestamp into a written date&time, in the phone's timezone
 get_timezoned_date(int timestamp) - turns a unix timestamp into a written date, in the phone's timezone
 int time() - returns unix timestamp
 
 */

import UIKit
import Foundation

class CMS_Timestamps: NSObject {
    
    /**
     *  Turns a unix timestamp into a written date&time, in the phone's timezone
     *
     *  @param timestamp   unix timestamp to be converted
     *  @param includeTime should time be considered from the timestamp ? YES - consider time, NO - discard time
     *
     *  @return String representation of the supplied timestamp
     */
    class func get_timezoned_date_time(timestamp: Int) -> String {
        var localDate = NSDate(timeIntervalSince1970: timestamp)
        var dateFormatter = NSDateFormatter()
        dateFormatter.dateFormat = "MMM dd, yyyy - HH:mm:ss"
        return dateFormatter.stringFromDate(localDate)
    }
    
    /**
     *  Turns a unix timestamp into a written date, in the phone's timezone
     *
     *  @param timestamp   unix timestamp to be converted
     *  @param includeTime should time be considered from the timestamp ? YES - consider time, NO - discard time
     *
     *  @return String representation of the supplied timestamp
     */
    class func get_timezoned_date(timestamp: Int) -> String {
        var localDate = NSDate(timeIntervalSince1970: timestamp)
        var dateFormatter = NSDateFormatter()
        dateFormatter.dateFormat = "MMM dd, yyyy"
        return dateFormatter.stringFromDate(localDate)
    }
    
    /**
     *  Returns unix timestamp
     *
     *  @return returns unix timestamp
     */
    class func time() -> Int {
        return NSDate().timeIntervalSince1970
    }
}